/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.root;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Build;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class MainResponse
extends ActionResponse
implements ToXContentObject {
    private final String nodeName;
    private final String luceneVersion;
    private final ClusterName clusterName;
    private final String clusterUuid;
    private final Build build;

    public MainResponse(String nodeName, String luceneVersion, ClusterName clusterName, String clusterUuid, Build build) {
        this.nodeName = nodeName;
        this.luceneVersion = luceneVersion;
        this.clusterName = clusterName;
        this.clusterUuid = clusterUuid;
        this.build = build;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getLuceneVersion() {
        return this.luceneVersion;
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    public String getClusterUuid() {
        return this.clusterUuid;
    }

    public Build getBuild() {
        return this.build;
    }

    public void writeTo(StreamOutput out) throws IOException {
        TransportAction.localOnly();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("name", this.nodeName);
        builder.field("cluster_name", this.clusterName.value());
        builder.field("cluster_uuid", this.clusterUuid);
        builder.startObject("version").field("number", this.build.qualifiedVersion()).field("build_flavor", this.build.flavor()).field("build_type", this.build.type().displayName()).field("build_hash", this.build.hash()).field("build_date", this.build.date()).field("build_snapshot", this.build.isSnapshot()).field("lucene_version", this.luceneVersion).field("minimum_wire_compatibility_version", this.build.minWireCompatVersion()).field("minimum_index_compatibility_version", this.build.minIndexCompatVersion()).endObject();
        builder.field("tagline", "You Know, for Search");
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MainResponse other = (MainResponse)((Object)o);
        return Objects.equals(this.nodeName, other.nodeName) && Objects.equals(this.luceneVersion, other.luceneVersion) && Objects.equals(this.clusterUuid, other.clusterUuid) && Objects.equals(this.build, other.build) && Objects.equals(this.clusterName, other.clusterName);
    }

    public int hashCode() {
        return Objects.hash(this.nodeName, this.luceneVersion, this.clusterUuid, this.build, this.clusterName);
    }

    public String toString() {
        return "MainResponse{nodeName='" + this.nodeName + "', luceneVersion=" + this.luceneVersion + ", clusterName=" + this.clusterName + ", clusterUuid='" + this.clusterUuid + "', build=" + this.build + "}";
    }
}

